program Globus3;

uses
  Forms,
  Windows,
  SysUtils,
  UnitFormPrincipal in 'UnitFormPrincipal.pas' {FormPrincipal},
  UnitFormSonograma in 'UnitFormSonograma.pas' {FormSonograma},
  UnitEntradaSo in 'UnitEntradaSo.pas' {FormEntradaSo},
  UnitCalculFFT in 'UnitCalculFFT.pas',
  UnitDadesGlobus2 in 'UnitDadesGlobus2.pas',
  UnitTools in 'UnitTools.pas',
  UnitGlobus in 'UnitGlobus.pas' {FormGlobus},
  UnitAtractor in 'UnitAtractor.pas' {FormAtractor},
  RainBow in 'rainbow.pas',
  UnitViatgeEnGlobus in 'UnitViatgeEnGlobus.pas' {FormViatgeEnGlobus},
  UnitCanviDeParametres in 'UnitCanviDeParametres.pas' {FormCanviDeParametres},
  UnitFemMoureUnCotxe in 'UnitFemMoureUnCotxe.pas' {FormFemMoureUnCotxe},
  Unitabout in 'Unitabout.pas' {AboutBox},
  UnitCursa in 'UnitCursa.pas' {FormCursa},
  UnitXupaXups in 'UnitXupaXups.pas' {FormXupaXups},
  UnitFormFractal in 'UnitFormFractal.pas' {FormFractal},
  UnitGrisos in 'UnitGrisos.pas' {FormGrisos},
  UnitMatematiques in 'UnitMatematiques.pas',
  UnitJocDelsRectangles in 'UnitJocDelsRectangles.pas' {FormJocRectangles},
  UnitReconeixementManualDeFonemes in 'UnitReconeixementManualDeFonemes.pas' {FormReconeixementManualDeFonemes},
  UnitEspectroscopi in 'UnitEspectroscopi.pas' {FormEspectroscopi},
  UnitEntradaDeSo in 'UnitEntradaDeSo.pas',
  UnitDades in 'UnitDades.pas',
  UnitCalculsLPC in 'UnitCalculsLPC.pas',
  UnitCalculsMatematics in 'UnitCalculsMatematics.pas',
  UnitEspectroscopiLPC in 'UnitEspectroscopiLPC.pas' {FormEspectroscopiLPC},
  UnitFormFrequencia in 'UnitFormFrequencia.pas' {FormFrequencia},
  UnitFormIntensitatDurada in 'UnitFormIntensitatDurada.pas' {FormIntensitatDurada},
  UnitArcDeSantMarti in 'UnitArcDeSantMarti.pas' {FormArcDeSantMarti},
  UnitFormPlasma in 'UnitFormPlasma.pas' {FormPlasma};

{$R *.RES}

var
  Hei:integer;
  n:integer;
  P:array[0..50] of char;

begin
  Application.Initialize;
  Application.CreateForm(TFormPrincipal, FormPrincipal);
  Application.CreateForm(TFormSonograma, FormSonograma);
  Application.CreateForm(TFormEntradaSo, FormEntradaSo);
  Application.CreateForm(TFormGlobus, FormGlobus);
  Application.CreateForm(TFormAtractor, FormAtractor);
  Application.CreateForm(TFormViatgeEnGlobus, FormViatgeEnGlobus);
  Application.CreateForm(TFormCanviDeParametres, FormCanviDeParametres);
  Application.CreateForm(TFormFemMoureUnCotxe, FormFemMoureUnCotxe);
  Application.CreateForm(TAboutBox, AboutBox);
  Application.CreateForm(TFormCursa, FormCursa);
  Application.CreateForm(TFormXupaXups, FormXupaXups);
  Application.CreateForm(TFormFractal, FormFractal);
  Application.CreateForm(TFormGrisos, FormGrisos);
  Application.CreateForm(TFormJocRectangles, FormJocRectangles);
  Application.CreateForm(TFormReconeixementManualDeFonemes, FormReconeixementManualDeFonemes);
  Application.CreateForm(TFormEspectroscopi, FormEspectroscopi);
  Application.CreateForm(TFormEspectroscopiLPC, FormEspectroscopiLPC);
  Application.CreateForm(TFormFrequencia, FormFrequencia);
  Application.CreateForm(TFormIntensitatDurada, FormIntensitatDurada);
  Application.CreateForm(TFormArcDeSantMarti, FormArcDeSantMarti);
  Application.CreateForm(TFormPlasma, FormPlasma);
  AboutBox.OKButton.Visible:=false;
  Hei:=AboutBox.Height;
  AboutBox.Height:=AboutBox.Height-28;
  AboutBox.Show;
  AboutBox.Timer1.Enabled:=false;
  Pausa(1000);
  AboutBox.Hide;
  AboutBox.Timer2.Enabled:=false;
  AboutBox.Copyright.ShowHint:=true;
  AboutBox.Height:=Hei;
  AboutBox.OKButton.Visible:=true;

  n:=50;
  //FormPrincipal.MenuCatalaClick(nil);
  FormPrincipal.Missatges[1]:='No puc obrir el fitxer o el fitxer no cont dades Globus-Sonograma';
  GetPrivateProfileString('globus 3','Llengua','NO',P,n,'globus3.ini');
  if StrPas(P)='NO' then GetPrivateProfileString('globus 2','Llengua','NO',P,n,'globus2.ini');
  if StrPas(P)='Castell' then begin
    FormPrincipal.MenuCastellanoClick(nil);
  end else if StrPas(P)='Euskera' then begin
    FormPrincipal.MenuEuskeraClick(nil);
  end else if StrPas(P)='Galego' then begin
    FormPrincipal.MenuGalegoClick(nil);
  end else if StrPas(P)='Portugues' then begin
    FormPrincipal.MenuPortuguesClick(nil);
  end else if StrPas(P)='English' then begin
    FormPrincipal.MenuEnglishClick(nil);
  end;

  GetPrivateProfileString('Globus','Decibels','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormGlobus.CheckBoxDecibels.Checked:=true;

  GetPrivateProfileString('Parametres','Maxim','128',P,n,'globus3.ini');
  if (StrToInt(StrPas(P))<=128) and (StrToInt(StrPas(P))>=1) then FormCanviDeParametres.EditMaxim.Text:=StrPas(P);
  GetPrivateProfileString('Parametres','Minim','20',P,n,'globus3.ini');
  if (StrToInt(StrPas(P))<=128) and (StrToInt(StrPas(P))>=1) then begin
    if StrToInt(StrPas(P))<StrToInt(FormCanviDeParametres.EditMaxim.Text) then begin
      FormCanviDeParametres.EditMinim.Text:=StrPas(P);
    end else begin
      FormCanviDeParametres.EditMaxim.Text:='128';
      FormCanviDeParametres.EditMinim.Text:='20';
    end;
  end;
  GetPrivateProfileString('Parametres','Increment X','2',P,n,'globus3.ini');
  if (StrToInt(StrPas(P))<=16) and (StrToInt(StrPas(P))>=1) then FormCanviDeParametres.EditIncrementX.Text:=StrPas(P);

  GetPrivateProfileString('Comparacio de patrons','Escala Y Decibels','SI',P,n,'globus3.ini');
  if StrPas(P)='NO' then FormEspectroscopiLPC.MenuEscalaYDecibels.Checked:=false;
  GetPrivateProfileString('Comparacio de patrons','Preenfasis','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormEspectroscopiLPC.MenuPreenfasis.Checked:=true;
  GetPrivateProfileString('Comparacio de patrons','Normalitzar Per Maxim','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormEspectroscopiLPC.MenuNormalitzarPerMaxim.Checked:=true;
  GetPrivateProfileString('Comparacio de patrons','Mel','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormEspectroscopiLPC.CheckBoxMel.Checked:=true;
  GetPrivateProfileString('Comparacio de patrons','Canvi Color Automatic','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormEspectroscopiLPC.CheckBoxCanviColorAutomatic.Checked:=true;
  GetPrivateProfileString('Comparacio de patrons','No repintar','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormEspectroscopiLPC.CheckBoxNoRepintar.Checked:=true;
  GetPrivateProfileString('Comparacio de patrons','Numero de quoeficients','20',P,n,'globus3.ini');
  FormEspectroscopiLPC.SpinEditNumeroQuoeficients.Value:=StrToInt(StrPas(P));
  GetPrivateProfileString('Comparacio de patrons','Mostrar so reconegut','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormEspectroscopiLPC.CheckBoxMostrarSoReconegut.Checked:=true;

  GetPrivateProfileString('Sonograma','EscalaY','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormSonograma.CheckBoxEscalaY.Checked:=true;
  GetPrivateProfileString('Sonograma','Circular','NO',P,n,'globus3.ini');
  if StrPas(P)='SI' then FormSonograma.CheckBoxCircular.Checked:=true;
  GetPrivateProfileString('Sonograma','Velocitat','4',P,n,'globus3.ini');
  FormSonograma.SpinEditVelocitat.Value:=StrToInt(StrPas(P));
  GetPrivateProfileString('Sonograma','Numero de quoeficients','20',P,n,'globus3.ini');
  FormSonograma.SpinEditNumeroQuoeficients.Value:=StrToInt(StrPas(P));

  Application.Run;
end.
